/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass.metadata;

import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.function.Function;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_790;
import org.jetbrains.annotations.Nullable;

public abstract class LBGState {
    private static final Object2ObjectMap<String, LBGStateProvider> LBG_STATES_TYPE = new Object2ObjectOpenHashMap();
    private static final Object2ObjectMap<class_2960, LBGState> LBG_STATES = new Object2ObjectOpenHashMap();
    public final class_2960 id;

    public LBGState(class_2960 id) {
        this.id = id;
        LBGState.putState(id, this);
    }

    protected boolean matchVariant(String modelVariant, String dataVariant) {
        return this.matchVariant(modelVariant.split(","), dataVariant.split(","));
    }

    protected boolean matchVariant(String[] modelVariant, String[] dataVariant) {
        for (String dataProperty : dataVariant) {
            if (dataProperty.equals("*")) {
                return true;
            }
            boolean matched = false;
            for (String modelProperty : modelVariant) {
                if (!modelProperty.equals(dataProperty)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public abstract class_1100 getCustomUnbakedModel(class_1091 var1, class_1100 var2, Function<class_2960, class_1100> var3);

    protected static void putState(class_2960 id, LBGState state) {
        LBG_STATES.put((Object)id, (Object)state);
    }

    @Nullable
    public static LBGState getMetadataState(class_2960 id) {
        return (LBGState)LBG_STATES.get((Object)id);
    }

    public static void reset() {
        LBG_STATES.clear();
    }

    public static void registerType(String type, LBGStateProvider stateProvider) {
        LBG_STATES_TYPE.put((Object)type, (Object)stateProvider);
    }

    @Nullable
    public static LBGState getOrLoadMetadataState(class_2960 id, class_3300 resourceManager, JsonObject json, class_790.class_791 deserializationContext) {
        LBGState state = LBGState.getMetadataState(id);
        if (state != null) {
            return state;
        }
        String type = "grass";
        if (json.has("type")) {
            type = json.get("type").getAsString();
        }
        if (!LBG_STATES_TYPE.containsKey((Object)type)) {
            return null;
        }
        return ((LBGStateProvider)LBG_STATES_TYPE.get((Object)type)).create(id, resourceManager, json, deserializationContext);
    }

    @FunctionalInterface
    public static interface LBGStateProvider {
        public LBGState create(class_2960 var1, class_3300 var2, JsonObject var3, class_790.class_791 var4);
    }
}

